<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\Admin;

use Erlage\Photogram\Data\Tables\AbstractTable;
use Erlage\Photogram\Data\Models\Admin\AdminModel;
use Erlage\Photogram\Data\Models\User\UserTransformer;

final class AdminTable extends AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | table data
    |--------------------------------------------------------------------------
    */

    const TABLE_NAME = 'admin';

    /*
    |--------------------------------------------------------------------------
    | fields/attributes
    |--------------------------------------------------------------------------
    */

    // ids

    const ID = 'id';

    // creds

    const USERNAME = 'username';

    const PASSWORD = 'password';

    // meta

    const META_ACCESS = 'meta_access';

    const META_LAST_ACTIVE = 'meta_last_active';

    // stamp

    const STAMP_REGISTRATION = 'stamp_registration';

    const STAMP_LAST_UPDATE = 'stamp_last_update';

    // extra fields(not present in database)
    const EXTRA_NEW_PASSWORD = 'extra_new_password';

    const EXTRA_RETYPE_NEW_PASSWORD = 'extra_retype_new_password';

    /*
    |--------------------------------------------------------------------------
    | all properties must provide their camel case equivalent
    |--------------------------------------------------------------------------
    */

    const CAMEL_CASE_MAP = array(
        self::ID                    => 'id',

        self::USERNAME              => 'username',
        self::PASSWORD              => 'password',

        self::META_ACCESS           => 'metaAccess',
        self::META_LAST_ACTIVE      => 'metaLastActive',

        self::STAMP_REGISTRATION    => 'stampRegistration',
        self::STAMP_LAST_UPDATE     => 'stampLastUpdate',
    );

    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return self::ID;
    }

    public static function getRegistrationStampAttribute(): string
    {
        return self::STAMP_REGISTRATION;
    }

    public static function getLastUpdateStampAttribute(): string
    {
        return self::STAMP_LAST_UPDATE;
    }

    public static function getOwnerAttribute(): string
    {
        return self::ID;
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getTableName(): string
    {
        return self::TABLE_NAME;
    }

    public static function getModelClassName(): string
    {
        return AdminModel::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | table properties getters
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        return self::CAMEL_CASE_MAP;
    }

    public static function privateAttributes(): array
    {
        return array(
            self::META_ACCESS        => self::CAMEL_CASE_MAP[self::META_ACCESS],
            self::STAMP_REGISTRATION => self::CAMEL_CASE_MAP[self::STAMP_REGISTRATION],
        );
    }

    public static function protectedAttributes(): array
    {
        return array(
            self::PASSWORD          => self::CAMEL_CASE_MAP[self::PASSWORD],
            self::STAMP_LAST_UPDATE => self::CAMEL_CASE_MAP[self::STAMP_LAST_UPDATE],
        );
    }

    /*
    |--------------------------------------------------------------------------
    | table modifiers
    |--------------------------------------------------------------------------
    */

    public static function transformers(): array
    {
        return array(
            self::PASSWORD    => array(UserTransformer::erlClass(), self::CAMEL_CASE_MAP[self::PASSWORD]),
            self::META_ACCESS => array(UserTransformer::erlClass(), self::CAMEL_CASE_MAP[self::META_ACCESS]),
        );
    }
}
